﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class PowerAmpDemoProgram
    {
        private bool[] lteEvmSetup = new bool[] {false, false, false};

        public void setLteSetupDirty()
        {
            lteEvmSetup = new bool[] { false, false, false };
        }

        // Test Procedures
        public int lteTest(string standard)
        {
            // Configure variables for LTE FDD 5 MHZ BW Standard
            string testWaveform = "";
            string testName = "";
            string etFileName = "";
            int lteIndex = 0;
            switch (standard)
            {
                case "B5M":
                    testWaveform = lte5MhzArb;
                    etFileName = lte5MhzEtArb;
                    iqDelay = 213e-9;
                    testName = "LTE FDD 5 MHz Test";
                    vsag.setupParameters("LTE_FDD_5MHZ");
                    dataLog.tstName = "LTE 5";
                    break;
                case "B10M":
                    testWaveform = lte10MhzArb;
                    etFileName = lte10MhzEtArb;
                    iqDelay = 183e-9;
                    testName = "LTE FDD 10 MHz Test";
                    vsag.setupParameters("LTE_FDD_10MHZ");
                    dataLog.tstName = "LTE 10";
                    lteIndex = 1;
                    break;
                case "B20M":
                    testWaveform = lte20MhzArb;
                    etFileName = lte20MhzEtArb;
                    iqDelay = 172e-9;
                    testName = "LTE FDD 20 MHz Test";
                    vsag.setupParameters("LTE_FDD_20MHZ");
                    dataLog.tstName = "LTE 20";
                    lteIndex = 2;
                    break;
            }

            dataLog.addResultsHeader(testName);
            //Start Test timer
            sw.Reset();
            sw.Start();

            if (enableEt)
            {
                // Configuration for ET:
                // 1.  Stop RF AWG Playback
                // 2.  Start ET AWG playback with External Trigger
                // 3.  Start RF AWG on 10 MHz clock edge using Baseband Delay to adjust timing
                vsag.stopModulation();
                etArb.startAwgWaveformTriggered(etFileName, arbAmplitude, arbOffset, 0.0, true);
                // Setup the VSG and VSA for waveform, band frequency and power level
                vsag.setVsgIqDelay(iqDelay + iqDelayOffset);
            }

            // External trigger and short waveforms will improve and repeatability, but will increase test times
            bool useExtTrig = true; 

            // Configure for External Trigger on ARB Wrap signal
            vsag.configVsaTrigger("EXTERNAL");

            if (enableEt)
            {
                // Match the length of the ET waveforms 
                vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain, true, etWaveformLength);
            }
            else if (!enableEt && testEvm)
            {
                // To measure EVM also, we need a 2.5 ms minimum length waveform
                vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain, true, 2.5e-3);
            }
            else
            {
                // If we are not measuring EVM, we can use a waveform just longer than the ACPR measurement duration
                vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain, true);
            }

            // Configure the EVM measurement
            if (testEvm)
            {
                if (lteEvmSetup[lteIndex] == false)
                {
                    vsag.configLteEvmMeas("ULIN", standard, cellFreqs[0], targetPout);
                    lteEvmSetup[lteIndex] = true;
                }
                else
                {
                    vsag.sendXappScpi("INST:SEL LTE\n");
                    string cmd = string.Format("SENSe:RADio:STANdard:BANDwidth {0}\n", standard);
                    vsag.sendXappScpi(cmd);
                    //Lib.sendXappScpi(":TRIG:CEVM:SEQ:SOUR EXT2\n");
                    //vsag.sendXappScpi("CEVM:EVM:COPY\n");
                }
            }

            // Loop over Frequencies for Low Band
            for (int i = 0; i < cellFreqs.Length; i++)
            {
                dataLog.addResultsHeader("Frequency = " + (cellFreqs[i] / 1e6).ToString("0.0") +
                    " MHz, Output Power = " + targetPout.ToString("0.00") + " dBm");

                // Set VSG and VSA to test frequency
                vsag.setTestFreq(cellFreqs[i]);

                // Servo source until Pout is at correct value
                if (vsag.fftServo)
                    vsag.servoInputPowerFft(targetPout, poutMargin);
                else
                    vsag.servoInputPower(targetPout, poutMargin);

                if (testCurr)
                {
                    // Measure DC Current
                    dcSmu.measCurrent();
                }

                if (testAcpr)
                {
                    // Use the IVI Driver to Measure ACPR
                    if (vsag.fftAcpr)
                        vsag.measLteFftAcpr();
                    else
                        vsag.measLteAcpr();
                }

                if (testEvm)
                {
                    // Measure EVM with X-App
                    // Unlock receiver from driver before starting, lock receiver and update setup when complete
                    vsag.unlockVsa();
                    vsag.setXappFreq(cellFreqs[i]);
                    vsag.measLteEvm();
                    vsag.lockVsa();

                    if (useExtTrig)
                    {
                        // Configure for External Trigger on ARB Wrap signal
                        vsag.configVsaTrigger("EXTERNAL");
                    }
                    vsag.setupVsa(cellFreqs[i], targetPout);
                }

                if (testHarms)
                {
                    // Measure Harmonics using Spectrum Method
#if M9393
                    bool[] harmsToMeas = new bool[numCellHarms];

                    for (int harmIdx = 0; harmIdx < numCellHarms; harmIdx++)
                    {
                        harmsToMeas[harmIdx] = true;
                    }
                    vsag.measSpecHarms2(harmsToMeas);
#else
                    vsag.measSpecHarms(true, true);
#endif
                }



                // Tests complete, setup for next test
                dataLog.nextTest();
            }
            // Put it back to immediate trigger
            // Configure for External Trigger on ARB Wrap signal
            vsag.configVsaTrigger("IMMEDIATE");


            // Update results and data log for end of test
            dataLog.addResultsFooter(testName, sw.ElapsedMilliseconds);
            return 0;
        }
    }
}